/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.aikar.commands;

import java.util.HashSet;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.skinsrestorer.shadow.aikar.commands.ACFPatterns;
import net.skinsrestorer.shadow.aikar.commands.ACFSpongeUtil;
import net.skinsrestorer.shadow.aikar.commands.ACFUtil;
import net.skinsrestorer.shadow.aikar.commands.CommandContexts;
import net.skinsrestorer.shadow.aikar.commands.InvalidCommandArgument;
import net.skinsrestorer.shadow.aikar.commands.LogLevel;
import net.skinsrestorer.shadow.aikar.commands.MessageKeys;
import net.skinsrestorer.shadow.aikar.commands.MinecraftMessageKeys;
import net.skinsrestorer.shadow.aikar.commands.SpongeCommandExecutionContext;
import net.skinsrestorer.shadow.aikar.commands.SpongeCommandIssuer;
import net.skinsrestorer.shadow.aikar.commands.SpongeCommandManager;
import net.skinsrestorer.shadow.aikar.commands.contexts.CommandResultSupplier;
import net.skinsrestorer.shadow.aikar.commands.sponge.contexts.OnlinePlayer;
import net.skinsrestorer.shadow.aikar.locales.MessageKeyProvider;
import net.skinsrestorer.shadow.jbannotations.Contract;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.world.World;

public class SpongeCommandContexts
extends CommandContexts<SpongeCommandExecutionContext> {
    public SpongeCommandContexts(SpongeCommandManager manager) {
        super(manager);
        this.registerIssuerOnlyContext(CommandResultSupplier.class, c -> new CommandResultSupplier());
        this.registerContext(OnlinePlayer.class, c -> this.getOnlinePlayer((SpongeCommandIssuer)c.getIssuer(), c.popFirstArg(), false));
        this.registerContext(net.skinsrestorer.shadow.aikar.commands.contexts.OnlinePlayer.class, c -> {
            OnlinePlayer onlinePlayer = this.getOnlinePlayer((SpongeCommandIssuer)c.getIssuer(), c.popFirstArg(), false);
            return new net.skinsrestorer.shadow.aikar.commands.contexts.OnlinePlayer(onlinePlayer.getPlayer());
        });
        this.registerContext(User.class, c -> {
            String name = c.popFirstArg();
            Optional targetPlayer = Sponge.getGame().getServer().getPlayer(name);
            if (targetPlayer.isPresent()) {
                return (User)targetPlayer.get();
            }
            Optional service = Sponge.getGame().getServiceManager().provide(UserStorageService.class);
            if (!service.isPresent()) {
                manager.log(LogLevel.ERROR, "No UserStorageService is available", new Error());
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.ERROR_GENERIC_LOGGED, false, new String[0]);
            }
            Optional user = ((UserStorageService)service.get()).get(name);
            if (user.isPresent()) {
                return (User)user.get();
            }
            if (!c.isOptional()) {
                throw new InvalidCommandArgument((MessageKeyProvider)MinecraftMessageKeys.NO_PLAYER_FOUND, false, "{search}", name);
            }
            return null;
        });
        this.registerContext(TextColor.class, c -> {
            String first = c.popFirstArg();
            Stream<Object> colours = Sponge.getRegistry().getAllOf(TextColor.class).stream();
            String filter = c.getFlagValue("filter", (String)null);
            if (filter != null) {
                String finalFilter = filter = ACFUtil.simplifyString(filter);
                colours = colours.filter(colour -> finalFilter.equals(ACFUtil.simplifyString(colour.getName())));
            }
            Stream finalColours = colours;
            return (TextColor)Sponge.getRegistry().getType(TextColor.class, ACFUtil.simplifyString(first)).orElseThrow(() -> {
                String valid = finalColours.map(colour -> "<c2>" + ACFUtil.simplifyString(colour.getName()) + "</c2>").collect(Collectors.joining("<c1>,</c1> "));
                return new InvalidCommandArgument((MessageKeyProvider)MessageKeys.PLEASE_SPECIFY_ONE_OF, "{valid}", valid);
            });
        });
        this.registerContext(TextStyle.Base.class, c -> {
            String first = c.popFirstArg();
            Stream<Object> styles = Sponge.getRegistry().getAllOf(TextStyle.Base.class).stream();
            String filter = c.getFlagValue("filter", (String)null);
            if (filter != null) {
                String finalFilter = filter = ACFUtil.simplifyString(filter);
                styles = styles.filter(style -> finalFilter.equals(ACFUtil.simplifyString(style.getName())));
            }
            Stream finalStyles = styles;
            return (TextStyle.Base)Sponge.getRegistry().getType(TextStyle.Base.class, ACFUtil.simplifyString(first)).orElseThrow(() -> {
                String valid = finalStyles.map(style -> "<c2>" + ACFUtil.simplifyString(style.getName()) + "</c2>").collect(Collectors.joining("<c1>,</c1> "));
                return new InvalidCommandArgument((MessageKeyProvider)MessageKeys.PLEASE_SPECIFY_ONE_OF, "{valid}", valid);
            });
        });
        this.registerIssuerAwareContext(CommandSource.class, SpongeCommandExecutionContext::getSource);
        this.registerIssuerAwareContext(Player.class, c -> {
            Player player;
            Player player2 = player = c.getSource() instanceof Player ? (Player)c.getSource() : null;
            if (player == null && !c.isOptional()) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.NOT_ALLOWED_ON_CONSOLE, false, new String[0]);
            }
            return player;
        });
        this.registerContext(OnlinePlayer[].class, c -> {
            SpongeCommandIssuer issuer = (SpongeCommandIssuer)c.getIssuer();
            String search = c.popFirstArg();
            boolean allowMissing = c.hasFlag("allowmissing");
            HashSet<OnlinePlayer> players = new HashSet<OnlinePlayer>();
            Pattern split = ACFPatterns.COMMA;
            String splitter = c.getFlagValue("splitter", (String)null);
            if (splitter != null) {
                split = Pattern.compile(Pattern.quote(splitter));
            }
            for (String lookup : split.split(search)) {
                OnlinePlayer player = this.getOnlinePlayer(issuer, lookup, allowMissing);
                if (player == null) continue;
                players.add(player);
            }
            if (players.isEmpty() && !c.hasFlag("allowempty")) {
                issuer.sendError(MinecraftMessageKeys.NO_PLAYER_FOUND_SERVER, "{search}", search);
                throw new InvalidCommandArgument(false);
            }
            return players.toArray(new OnlinePlayer[players.size()]);
        });
        this.registerIssuerAwareContext(World.class, c -> {
            Optional<World> world;
            String firstArg = c.getFirstArg();
            Optional<World> optional = world = firstArg != null ? Sponge.getServer().getWorld(firstArg) : Optional.empty();
            if (world.isPresent()) {
                c.popFirstArg();
            }
            if (!world.isPresent() && c.getSource() instanceof Player) {
                world = Optional.of(((Player)c.getSource()).getWorld());
            }
            if (!world.isPresent()) {
                throw new InvalidCommandArgument((MessageKeyProvider)MinecraftMessageKeys.INVALID_WORLD, new String[0]);
            }
            return (World)world.get();
        });
    }

    @Contract(value="_,_,false -> !null")
    OnlinePlayer getOnlinePlayer(SpongeCommandIssuer issuer, String lookup, boolean allowMissing) throws InvalidCommandArgument {
        Player player = ACFSpongeUtil.findPlayerSmart(issuer, lookup);
        if (player == null) {
            if (allowMissing) {
                return null;
            }
            throw new InvalidCommandArgument(false);
        }
        return new OnlinePlayer(player);
    }
}

